/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.core;

import de.joergjahnke.c64.core.C1541;
import de.joergjahnke.c64.core.EmulatedDevice;
import de.joergjahnke.c64.core.VIA6522;
import de.joergjahnke.c64.drive.DiskDriveHandler;
import de.joergjahnke.common.util.Observer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VIA6522_DC
extends VIA6522
implements Observer {
    private static final boolean DEBUG = false;
    private static final int PB_STEPPER_MOTOR = 3;
    private static final int PB_DRIVE_MOTOR = 4;
    public static final int PB_LED = 8;
    public static final int PB_WRITE_PROTECTED = 16;
    public static final int PB_SYNC = 128;
    private static final int MIN_HALFTRACK = 2;
    private static final int MAX_HALFTRACK = 70;
    private static final int SYNC_SIZE = 1;
    private static final int HEADER_SIZE = 10;
    private static final int GAP1_SIZE = 9;
    private static final int DATA_SIZE = 325;
    private static final int GAP2_SIZE = 8;
    private static final int GCR_SECTOR_SIZE = 354;
    private static final int SYNC = 511;
    private static final int GAP = 85;
    private static final int HEADER_START = 8;
    private static final int BLOCK_START = 7;
    private static final int GAP_DATA = 15;
    private static final int[] GCR_TABLE = new int[]{10, 11, 18, 19, 14, 15, 22, 23, 9, 25, 26, 27, 13, 29, 30, 21};
    private static final int[] GCR_INV_TABLE;
    protected static final int INTERVAL_MOVE_TO_NEXT_BYTE = 30;
    private static final int INTERVAL_MOVE_TO_NEXT_SYNC = 1000;
    private static final int INTERVAL_MOVE_TO_NEXT_TRACK = 0;
    private boolean wasDiskChanged = false;
    private int currentHalfTrack = 2;
    private int track = 1;
    private int sector = 0;
    private int[] gcrSector = null;
    private int gcrPos = -1;
    private long shiftGCR = 0L;
    private int bytesGCR = 0;
    private boolean wasSectorModified = false;
    protected long nextMove = 0L;
    private boolean isByteReady = false;
    private boolean isWriteMode = false;

    static {
        int[] nArray = new int[32];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = 8;
        nArray[11] = 1;
        nArray[12] = -1;
        nArray[13] = 12;
        nArray[14] = 4;
        nArray[15] = 5;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = -1;
        nArray[21] = 15;
        nArray[22] = 6;
        nArray[23] = 7;
        nArray[24] = -1;
        nArray[25] = 9;
        nArray[26] = 10;
        nArray[27] = 11;
        nArray[28] = -1;
        nArray[29] = 13;
        nArray[30] = 14;
        nArray[31] = -1;
        GCR_INV_TABLE = nArray;
    }

    public VIA6522_DC(C1541 c1541) {
        super(c1541);
        c1541.addObserver(this);
    }

    @Override
    public void synchronizeWithDevice(EmulatedDevice device) {
        super.synchronizeWithDevice(device);
        this.nextMove = device.getCPU().getCycles();
    }

    public final boolean isByteReady() {
        boolean result = this.isByteReady | (this.isMotorOn() && !this.c1541.isEmulateDiskRotation());
        this.isByteReady = false;
        return result;
    }

    public final boolean isLEDOn() {
        return (this.registers[0] & 8) != 0;
    }

    public final boolean isMotorOn() {
        return (this.registers[0] & 4) != 0;
    }

    private void halfTrackChanged() {
        if (this.currentHalfTrack % 2 == 0) {
            this.track = this.currentHalfTrack / 2;
            this.sector = 0;
            this.readSector();
            this.nextMove += 0L;
        }
        this.c1541.markActive();
    }

    protected void rotateDisk() {
        if (this.isWriteMode && this.gcrPos >= 0 && this.registers[3] == 255 && this.registers[1] != this.gcrSector[this.gcrPos]) {
            this.gcrSector[this.gcrPos] = this.registers[1];
            this.wasSectorModified = true;
        }
        ++this.gcrPos;
        if (this.gcrPos >= 354) {
            if (this.wasSectorModified) {
                this.writeSector();
            }
            ++this.sector;
            if (this.sector >= DiskDriveHandler.SECTORS_PER_TRACK[this.track - 1]) {
                this.sector = 0;
            }
            this.readSector();
            this.nextMove += 1000L;
        }
        if (!this.isWriteMode && this.gcrPos >= 0) {
            this.registers[1] = this.gcrSector[this.gcrPos] & 0xFF;
        }
        this.isByteReady = this.isWriteMode | !this.isSync();
    }

    protected void proceedToNextSync() {
        while (!this.isSync()) {
            this.rotateDisk();
        }
    }

    protected void writeSync() {
        this.gcrSector[this.gcrPos] = 511;
        if (!this.c1541.isEmulateDiskRotation()) {
            this.rotateDisk();
        }
    }

    private void readSector() {
        this.gcrSector = new int[354];
        this.gcrPos = 0;
        this.shiftGCR = 0L;
        this.bytesGCR = 0;
        this.gcrSector[this.gcrPos++] = 511;
        int diskID1 = this.c1541.getDriveHandler().getDiskID()[0];
        int diskID2 = this.c1541.getDriveHandler().getDiskID()[1];
        this.writeGCRByte(8);
        this.writeGCRByte(this.sector ^ this.track ^ diskID1 ^ diskID2);
        this.writeGCRByte(this.sector);
        this.writeGCRByte(this.track);
        this.writeGCRByte(diskID2);
        this.writeGCRByte(diskID1);
        this.writeGCRByte(15);
        this.writeGCRByte(15);
        int i = 0;
        while (i < 9) {
            this.gcrSector[this.gcrPos++] = 85;
            ++i;
        }
        this.gcrSector[this.gcrPos++] = 511;
        this.c1541.getDriveHandler().gotoBlock(this.track, this.sector);
        byte[] bytes = this.c1541.getDriveHandler().readBlock();
        if (bytes.length != 256) {
            throw new RuntimeException("Illegal block length of " + bytes.length + " bytes when converting to GCR block!");
        }
        int checksum = 0;
        this.writeGCRByte(7);
        int i2 = 0;
        while (i2 < bytes.length) {
            int data = bytes[i2] & 0xFF;
            this.writeGCRByte(data);
            checksum ^= data;
            ++i2;
        }
        this.writeGCRByte(checksum);
        this.writeGCRByte(0);
        this.writeGCRByte(0);
        i2 = 0;
        while (i2 < 8) {
            this.gcrSector[this.gcrPos++] = 85;
            ++i2;
        }
        if (this.bytesGCR != 0) {
            throw new RuntimeException("Wrong conversion of GCR bytes!");
        }
        if (this.gcrPos != 354) {
            throw new RuntimeException("GCR sector too short!");
        }
        this.wasSectorModified = false;
        this.gcrPos = -1;
        this.registers[1] = 0;
    }

    private void writeGCRByte(int data) {
        this.shiftGCR <<= 5;
        this.shiftGCR |= (long)GCR_TABLE[data >> 4];
        this.shiftGCR <<= 5;
        this.shiftGCR |= (long)GCR_TABLE[data & 0xF];
        if (++this.bytesGCR >= 4) {
            int shift = 32;
            while (shift >= 0) {
                this.gcrSector[this.gcrPos++] = (int)(this.shiftGCR >> shift & 0xFFL);
                shift -= 8;
            }
            this.shiftGCR = 0L;
            this.bytesGCR = 0;
        }
    }

    private void writeSector() {
        byte[] bytes = new byte[256];
        this.shiftGCR = 0L;
        this.bytesGCR = 0;
        this.gcrPos = 21;
        int data = this.readGCRByte();
        if (data != 7) {
            throw new RuntimeException("Writing illegal block start byte to disk!");
        }
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)this.readGCRByte();
            ++i;
        }
        this.c1541.getDriveHandler().writeBlock(bytes);
        this.c1541.markActive();
    }

    private int readGCRByte() {
        if (this.bytesGCR <= 0) {
            this.shiftGCR = 0L;
            this.bytesGCR = 4;
            int shift = 32;
            while (shift >= 0) {
                this.shiftGCR |= (long)(this.gcrSector[this.gcrPos++] & 0xFF) << shift;
                shift -= 8;
            }
        }
        int data = (int)(this.shiftGCR >> --this.bytesGCR * 10 & 0x3FFL);
        int high = GCR_INV_TABLE[data >> 5];
        int low = GCR_INV_TABLE[data & 0x1F];
        if (high < 0 || low < 0) {
            throw new RuntimeException("Error when converting GCR bytes!");
        }
        return high << 4 | low;
    }

    private boolean isSync() {
        return this.gcrPos >= 0 && this.gcrSector[this.gcrPos] == 511;
    }

    private boolean isWriteProtect() {
        return this.wasDiskChanged;
    }

    @Override
    public void reset() {
        super.reset();
        this.bytesGCR = 0;
        this.shiftGCR = 0L;
        this.wasDiskChanged = false;
        this.currentHalfTrack = 2;
        this.track = 1;
        this.sector = 0;
        this.gcrPos = -1;
    }

    @Override
    public int readRegister(int register) {
        switch (register) {
            case 0: {
                int result = super.readRegister(register) & 0x6F | (this.isWriteProtect() ? 0 : 16) | (this.isSync() ? 0 : 128);
                this.wasDiskChanged = false;
                if (!this.isSync() && !this.c1541.isEmulateDiskRotation() && this.gcrSector != null) {
                    this.rotateDisk();
                }
                return result;
            }
            case 1: 
            case 15: {
                int result = this.registers[1];
                if (!this.c1541.isEmulateDiskRotation() && this.gcrSector != null) {
                    this.rotateDisk();
                }
                return result;
            }
        }
        return super.readRegister(register);
    }

    @Override
    public void writeRegister(int register, int data) {
        switch (register) {
            case 0: {
                int oldMotor = this.registers[0] & 3;
                if (oldMotor == (data + 1 & 3)) {
                    this.currentHalfTrack = Math.max(2, this.currentHalfTrack - 1);
                    this.halfTrackChanged();
                } else if (oldMotor == (data - 1 & 3)) {
                    this.currentHalfTrack = Math.min(70, this.currentHalfTrack + 1);
                    this.halfTrackChanged();
                }
                super.writeRegister(register, data);
                break;
            }
            case 1: {
                super.writeRegister(register, data);
                if (this.c1541.isEmulateDiskRotation() || this.gcrSector == null) break;
                this.rotateDisk();
                break;
            }
            case 12: {
                this.isWriteMode = (data & 0x20) == 0;
                super.writeRegister(register, data);
                break;
            }
            default: {
                super.writeRegister(register, data);
            }
        }
    }

    @Override
    public void serialize(DataOutputStream out) throws IOException {
        super.serialize(out);
        out.writeBoolean(this.wasDiskChanged);
        out.writeInt(this.currentHalfTrack);
        out.writeInt(this.track);
        out.writeInt(this.sector);
        int size = this.gcrSector == null ? 0 : this.gcrSector.length;
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            out.writeInt(this.gcrSector[i]);
            ++i;
        }
        out.writeInt(this.gcrPos);
        out.writeLong(this.shiftGCR);
        out.writeInt(this.bytesGCR);
        out.writeBoolean(this.wasSectorModified);
        out.writeLong(this.nextMove);
        out.writeBoolean(this.isByteReady);
        out.writeBoolean(this.isWriteMode);
    }

    @Override
    public void deserialize(DataInputStream in) throws IOException {
        super.deserialize(in);
        this.wasDiskChanged = in.readBoolean();
        this.currentHalfTrack = in.readInt();
        this.track = in.readInt();
        this.sector = in.readInt();
        int size = in.readInt();
        if (size > 0) {
            this.gcrSector = new int[size];
            int i = 0;
            while (i < size) {
                this.gcrSector[i] = in.readInt();
                ++i;
            }
        } else {
            this.gcrSector = null;
        }
        this.gcrPos = in.readInt();
        this.shiftGCR = in.readLong();
        this.bytesGCR = in.readInt();
        this.wasSectorModified = in.readBoolean();
        this.nextMove = in.readLong();
        this.isByteReady = in.readBoolean();
        this.isWriteMode = in.readBoolean();
    }

    @Override
    public void update(Object observed, Object arg) {
        if (observed == this.c1541 && arg == C1541.DISK_MOUNTED) {
            this.wasDiskChanged = true;
        }
    }
}

